package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Obtention de la liste des algorithmes supports par la carte
 *
 */
public class ListerAlgo{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(ListerAlgo.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSlotToken Identifiant du slot hbergeant la carte
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSlotToken) throws ExceptionTraitement {


		try {
		
			if(librairie != null) {
		
				ResultatInfo resultat = new ResultatInfo("Obtenir la liste des algorithmes supports par la carte ");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);		
		
				try {
					
					// Rcupration du libell de la carte
					CK_TOKEN_INFO info = librairie.C_GetTokenInfo(idSlotToken);
					
					if(info != null)
						resultat.appendTraitement(new String(info.label).trim()+" (C_GetMechanismList)");
					else
						resultat.appendTraitement("(C_GetMechanismList)");
					
				} catch (PKCS11Exception e) {
					
					// On ne fait rien, il ne s'agit pas de la fonction que l'on teste dans ce traitement
				}
				
				try {
					
					// Traitement  tester
					long[] mechanisms = librairie.C_GetMechanismList(idSlotToken);
					
					// Formatage du resultat
					if(mechanisms != null) {
						infos.put("Nombre d'algorithmes supports:",Integer.toString(mechanisms.length));
						for (int i = 0; i < mechanisms.length; i++) {
							long mechanism = mechanisms[i];
							resultat.getObjets().add(mechanism);
							infos.put("Algorithme "+(i+1),TraitementsUtil.getNomAlgo(mechanism));
						}
					} else {
						
						// Si la liste des algorithmes retourne est nulle on lve l'exception
						log.error("La liste des algorithmes retournee est nulle");
						throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_LISTE_ALGO, "La liste des algorithmes retourne est nulle");
						
					}
					
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
				
			} else {
	
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_LISTE_ALGO, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_LISTE_ALGO, "Une erreur inattendue est survenue");
			
		}
	}

}
